package gov.va.med.mhv.phr.decorator;

import java.util.Date;

import org.displaytag.exception.DecoratorException;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.core.web.decorator.DefaultDateDecorator;

/**
 * Decorates date value columns, formating the columns in a standard manner.
 * This class adds a type check to the DefaultDateDecorator and returns a
 * blank string, rather than a null for null values.
 * @author Rob Proper
 */
public class DateColumnDecorator extends DefaultDateDecorator {
	
	/**
	 * Converts the value to a formatted date string.
	 * @param value The date value to convert to a formatted date string.
	 * @see org.displaytag.decorator.ColumnDecorator#decorate(java.lang.Object)
	 * @throws IllegalArgumentException When the provided value is not a date.
	 */
	@SuppressWarnings("deprecation")
    public String decorate(Object value) throws DecoratorException {
		String decoratedValue = "";
		if (value != null) {
			Precondition.assertAssignableFrom("value", value, Date.class);
			decoratedValue = super.decorate(value);
		}
		return decoratedValue;
	}
	
	
}
